/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.HttpDeleteWithBody;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGridResponseHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Client {
    private CloseableHttpClient httpClient;
    private Boolean test;

    public Client() {
        this.httpClient = HttpClients.createDefault();
        this.test = false;
    }

    public Client(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        this.test = false;
    }

    public Client(Boolean test) {
        this.httpClient = HttpClients.createDefault();
        this.test = test;
    }

    public URI buildUri(String baseUri, String endpoint, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        if (this.test.booleanValue()) {
            builder.setScheme("http");
        } else {
            builder.setScheme("https");
        }
        builder.setHost(baseUri);
        builder.setPath(endpoint);
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        URI uri = builder.build();
        return uri;
    }

    public Response getResponse(CloseableHttpResponse response) throws IOException {
        SendGridResponseHandler handler = new SendGridResponseHandler();
        String responseBody = "";
        int statusCode = response.getStatusLine().getStatusCode();
        responseBody = (String)handler.handleResponse((HttpResponse)response);
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header h : headers) {
            responseHeaders.put(h.getName(), h.getValue());
        }
        return new Response(statusCode, responseBody, responseHeaders);
    }

    public Response get(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpGet httpGet = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpGet = new HttpGet(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeApiCall((HttpRequestBase)httpGet);
    }

    public Response post(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPost httpPost = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPost = new HttpPost(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        if (request.getBody() != "") {
            httpPost.setHeader("Content-Type", "application/json");
        }
        return this.executeApiCall((HttpRequestBase)httpPost);
    }

    public Response patch(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPatch httpPatch = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPatch = new HttpPatch(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPatch.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPatch.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        if (request.getBody() != "") {
            httpPatch.setHeader("Content-Type", "application/json");
        }
        return this.executeApiCall((HttpRequestBase)httpPatch);
    }

    public Response put(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPut httpPut = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPut = new HttpPut(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPut.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPut.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        if (request.getBody() != "") {
            httpPut.setHeader("Content-Type", "application/json");
        }
        return this.executeApiCall((HttpRequestBase)httpPut);
    }

    public Response delete(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpDeleteWithBody httpDelete = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpDelete = new HttpDeleteWithBody(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpDelete.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpDelete.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        if (request.getBody() != "") {
            httpDelete.setHeader("Content-Type", "application/json");
        }
        return this.executeApiCall((HttpRequestBase)httpDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeApiCall(HttpRequestBase httpPost) throws IOException {
        Response response = new Response();
        try (CloseableHttpResponse serverResponse = null;){
            serverResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            response = this.getResponse(serverResponse);
            StatusLine statusLine = serverResponse.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new IOException("Request returned status Code " + statusLine.getStatusCode() + "Body:" + (response != null ? response.body : null));
            }
        }
        return response;
    }

    public Response api(Request request) throws IOException {
        try {
            if (request.getMethod() == null) {
                throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
            }
            switch (request.getMethod()) {
                case GET: {
                    return this.get(request);
                }
                case POST: {
                    return this.post(request);
                }
                case PUT: {
                    return this.put(request);
                }
                case PATCH: {
                    return this.patch(request);
                }
                case DELETE: {
                    return this.delete(request);
                }
            }
            throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (URISyntaxException ex) {
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            throw new IOException(errors.toString());
        }
    }
}

