/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.labs.vertx.schedule;

import com.sendgrid.labs.vertx.schedule.Scheduler;
import com.sendgrid.labs.vertx.schedule.SchedulerLogic;
import com.sendgrid.labs.vertx.schedule.TimeOfWeek;
import com.sendgrid.labs.vertx.schedule.Timer;
import com.sendgrid.labs.vertx.schedule.Utils;
import java.util.Date;
import java.util.HashMap;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

class SchedulerImpl
extends Scheduler {
    private Vertx vertx;
    private HashMap<Timer, TimerData> timers;

    public SchedulerImpl(Vertx vertx) {
        this.vertx = vertx;
        this.timers = new HashMap();
    }

    @Override
    public void stop() {
        for (TimerData timer : this.timers.values()) {
            this.vertx.cancelTimer(timer.vertxTimerId.longValue());
        }
        this.timers.clear();
    }

    @Override
    public Timer setTimer(TimeOfWeek time, Handler<Timer> handler) {
        return this.start(false, time, handler);
    }

    @Override
    public Timer setPeriodic(TimeOfWeek time, Handler<Timer> handler) {
        return this.start(true, time, handler);
    }

    @Override
    public void cancelTimer(Timer timer) {
        if (this.timers.containsKey(timer)) {
            TimerData data = this.timers.get(timer);
            this.vertx.cancelTimer(data.vertxTimerId.longValue());
            this.timers.remove(timer);
        }
    }

    private Timer start(final boolean periodic, TimeOfWeek time, final Handler<Timer> handler) {
        final TimerData data = new TimerData();
        final Timer timer = new Timer();
        final SchedulerLogic logic = new SchedulerLogic(time.getTimeZone(), new Date(), time.getWeekMs(), time.aheadBehavior(), time.backBehavior());
        Handler<Long> timerCB = new Handler<Long>(){

            public void handle(Long vertxTimerId) {
                handler.handle((Object)timer);
                if (periodic) {
                    Date d = logic.next();
                    data.vertxTimerId = SchedulerImpl.this.vertx.setTimer(Utils.getMsUntilDate(logic.next()).longValue(), (Handler)this);
                } else {
                    SchedulerImpl.this.timers.remove(timer);
                }
            }
        };
        data.vertxTimerId = this.vertx.setTimer(Utils.getMsUntilDate(logic.next()).longValue(), (Handler)timerCB);
        this.timers.put(timer, data);
        return timer;
    }

    private class TimerData {
        Long vertxTimerId;

        private TimerData() {
        }
    }
}

