/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.labs.vertx.schedule;

import com.sendgrid.labs.vertx.schedule.EventInfo;
import com.sendgrid.labs.vertx.schedule.TimeOfWeek;
import com.sendgrid.labs.vertx.schedule.WeekTracker;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;

class SchedulerLogic {
    private WeekTracker weekTracker;
    private LinkedList<EventInfo> events;
    private TimeOfWeek.DstAheadBehavior aheadBehavior;
    private TimeOfWeek.DstBackBehavior backBehavior;

    public SchedulerLogic(TimeZone tz, Date start, int weekMs, TimeOfWeek.DstAheadBehavior aheadBehavior, TimeOfWeek.DstBackBehavior backBehavior) {
        this.weekTracker = new WeekTracker(tz, start, weekMs);
        this.aheadBehavior = aheadBehavior;
        this.backBehavior = backBehavior;
        this.events = this.weekTracker.get();
    }

    Date next() {
        EventInfo e;
        block4: {
            while (true) {
                if (this.events.size() < 1) {
                    this.weekTracker.advance();
                    this.events = this.weekTracker.get();
                }
                e = this.events.pop();
                if (e.isDstAheadHour) {
                    if (this.aheadBehavior != TimeOfWeek.DstAheadBehavior.DST_AHEAD_NEXT_HOUR) continue;
                    return e.date;
                }
                if (e.isDstBackHour1) {
                    if (this.backBehavior != TimeOfWeek.DstBackBehavior.DST_BACK_FIRST_HOUR && this.backBehavior != TimeOfWeek.DstBackBehavior.DST_BACK_BOTH_HOURS) continue;
                    return e.date;
                }
                if (!e.isDstBackHour2) break block4;
                if (this.backBehavior == TimeOfWeek.DstBackBehavior.DST_BACK_SECOND_HOUR || this.backBehavior == TimeOfWeek.DstBackBehavior.DST_BACK_BOTH_HOURS) break;
            }
            return e.date;
        }
        return e.date;
    }
}

