/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.labs.vertx.schedule;

import com.sendgrid.labs.vertx.schedule.Utils;
import java.util.TimeZone;

public class TimeOfWeek {
    private int weekMs;
    private TimeZone tz;
    private DstAheadBehavior ahead;
    private DstBackBehavior back;

    public static TimeOfWeek create(int weekMs) {
        return TimeOfWeek.create(TimeZone.getTimeZone("UTC"), weekMs);
    }

    public static TimeOfWeek create(TimeZone tz, int weekMs) {
        return TimeOfWeek.create(tz, weekMs, DstAheadBehavior.DST_AHEAD_SKIP, DstBackBehavior.DST_BACK_BOTH_HOURS);
    }

    public static TimeOfWeek create(TimeZone tz, int weekMs, DstAheadBehavior ahead, DstBackBehavior back) {
        TimeOfWeek w = new TimeOfWeek();
        w.weekMs = weekMs;
        w.tz = tz;
        w.ahead = ahead;
        w.back = back;
        return w;
    }

    public static TimeOfWeek create(Day day, int hour, int minute, int sec, int ms) {
        return TimeOfWeek.create(TimeZone.getTimeZone("UTC"), Utils.convertWeekTime(day, hour, minute, sec, ms));
    }

    public static TimeOfWeek create(TimeZone tz, Day day, int hour, int minute, int sec, int ms) {
        return TimeOfWeek.create(tz, Utils.convertWeekTime(day, hour, minute, sec, ms));
    }

    public static TimeOfWeek create(TimeZone tz, Day day, int hour, int minute, int sec, int ms, DstAheadBehavior ahead, DstBackBehavior back) {
        return TimeOfWeek.create(tz, Utils.convertWeekTime(day, hour, minute, sec, ms), ahead, back);
    }

    public int getWeekMs() {
        return this.weekMs;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public DstAheadBehavior aheadBehavior() {
        return this.ahead;
    }

    public DstBackBehavior backBehavior() {
        return this.back;
    }

    private TimeOfWeek() {
    }

    public static enum DstBackBehavior {
        DST_BACK_BOTH_HOURS,
        DST_BACK_FIRST_HOUR,
        DST_BACK_SECOND_HOUR;

    }

    public static enum DstAheadBehavior {
        DST_AHEAD_SKIP,
        DST_AHEAD_NEXT_HOUR;

    }

    public static enum Day {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

    }
}

