/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.labs.vertx.schedule;

import com.sendgrid.labs.vertx.schedule.EventInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;

class WeekTracker {
    private Calendar calendar;
    private LinkedList<EventInfo> events;
    private int weekMs;

    public WeekTracker(TimeZone tz, Date start, int weekMs) {
        this.calendar = Calendar.getInstance(tz);
        this.calendar.setLenient(true);
        this.calendar.setTime(start);
        this.calendar.set(7, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.weekMs = weekMs;
        this.loadInitialEvents(start);
    }

    public void advance() {
        this.calendar.add(5, 7);
        this.events = this.calculateThisWeeksEvents();
    }

    public LinkedList<EventInfo> get() {
        return this.events;
    }

    private void loadInitialEvents(Date start) {
        this.events = this.calculateThisWeeksEvents();
        while (this.events.size() > 0 && this.events.peek().date.before(start)) {
            this.events.pop();
        }
        if (this.events.size() < 1) {
            this.advance();
        }
    }

    private LinkedList<EventInfo> calculateThisWeeksEvents() {
        LinkedList<EventInfo> ret = new LinkedList<EventInfo>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        Calendar event = (Calendar)this.calendar.clone();
        event.add(14, this.weekMs);
        Calendar event_before = (Calendar)event.clone();
        event_before.add(12, -60);
        Calendar event_after = (Calendar)event.clone();
        event_after.add(12, 60);
        int start_of_week_dst_offset = this.calendar.get(16);
        int event_dst_offset = event.get(16);
        int hour_before_dst_offset = event_before.get(16);
        int hour_after_dst_offset = event_after.get(16);
        if (hour_before_dst_offset < event_dst_offset) {
            EventInfo e = new EventInfo();
            e.date = event.getTime();
            e.isDstAheadHour = true;
            e.isDstBackHour1 = false;
            e.isDstBackHour2 = false;
            ret.add(e);
        } else if (hour_before_dst_offset > event_dst_offset) {
            EventInfo e1 = new EventInfo();
            e1.date = event.getTime();
            e1.isDstAheadHour = false;
            e1.isDstBackHour1 = true;
            e1.isDstBackHour2 = false;
            ret.add(e1);
            EventInfo e2 = new EventInfo();
            event.add(12, 60);
            e2.date = event.getTime();
            e2.isDstAheadHour = false;
            e2.isDstBackHour1 = false;
            e2.isDstBackHour2 = true;
            ret.add(e2);
        } else {
            EventInfo e = new EventInfo();
            event.add(14, start_of_week_dst_offset - event_dst_offset);
            e.date = event.getTime();
            e.isDstAheadHour = false;
            e.isDstBackHour1 = false;
            e.isDstBackHour2 = false;
            ret.add(e);
        }
        return ret;
    }
}

