/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.constant.EnumConstants;
import com.sendgrid.exception.AuthenticationException;
import com.sendgrid.http.ApiKeyRestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiKeySendGrid {
    private static String apiKey = System.getenv("SENDGRID_API_KEY");
    private static String region = System.getenv("SENDGRID_REGION");
    private static List<String> userAgentExtensions;
    private static volatile ApiKeyRestClient apiKeyRestClient;

    private ApiKeySendGrid() {
    }

    public static synchronized void init(String apiKey) {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new AuthenticationException(String.format("'%s' can not be null or empty", "API_KEY"));
        }
        ApiKeySendGrid.apiKey = apiKey;
    }

    public static synchronized void setRegion(String region) {
        if (region == null || region.isEmpty()) {
            throw new AuthenticationException(String.format("'%s' can not be null or empty", "REGION"));
        }
        if (!EnumConstants.Region.getValues().contains(region)) {
            throw new AuthenticationException(String.format("'%s' is invalid", "REGION"));
        }
        if (!Objects.equals(region, ApiKeySendGrid.region)) {
            ApiKeySendGrid.invalidate();
        }
        ApiKeySendGrid.region = region;
    }

    public static synchronized void setUserAgentExtensions(List<String> userAgentExtensions) {
        ApiKeySendGrid.userAgentExtensions = userAgentExtensions != null && !userAgentExtensions.isEmpty() ? new ArrayList<String>(userAgentExtensions) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiKeyRestClient getRestClient() {
        if (apiKeyRestClient != null) return apiKeyRestClient;
        Class<ApiKeySendGrid> clazz = ApiKeySendGrid.class;
        synchronized (ApiKeySendGrid.class) {
            if (apiKeyRestClient != null) return apiKeyRestClient;
            apiKeyRestClient = ApiKeySendGrid.buildRestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return apiKeyRestClient;
        }
    }

    private static ApiKeyRestClient buildRestClient() {
        if (apiKey == null) {
            throw new AuthenticationException("Api Key is not initialized, please call ApiKeySendGrid.init()");
        }
        ApiKeyRestClient.Builder builder = new ApiKeyRestClient.Builder(apiKey);
        if (userAgentExtensions != null) {
            builder.userAgentExtensions(userAgentExtensions);
        }
        if (region == null) {
            builder.region(EnumConstants.Region.GLOBAL.getValue());
        } else {
            builder.region(region);
        }
        return builder.build();
    }

    private static void invalidate() {
        apiKeyRestClient = null;
    }

    public static List<String> getUserAgentExtensions() {
        return userAgentExtensions;
    }
}

