/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.http.auth.AuthStrategy;
import com.sendgrid.http.auth.TokenStrategy;
import com.sendgrid.http.httpclient.ApiKeyHttpClient;
import com.sendgrid.http.httpclient.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyRestClient {
    private final String apiKey;
    private final String region;
    private final ObjectMapper objectMapper;
    private final AuthStrategy tokenStrategy;
    private final HttpClient httpClient;
    private final List<String> userAgentExtensions;
    private static final Logger logger = LoggerFactory.getLogger(ApiKeyRestClient.class);

    protected ApiKeyRestClient(Builder builder) {
        this.apiKey = builder.apiKey;
        this.region = builder.region;
        this.userAgentExtensions = builder.userAgentExtensions;
        this.objectMapper = new ObjectMapper();
        this.tokenStrategy = new TokenStrategy(this.apiKey);
        this.httpClient = builder.httpClient;
    }

    public Response request(Request request) {
        this.tokenStrategy.applyAuth(request);
        if (this.region != null) {
            request.setRegion(this.region);
        }
        if (this.userAgentExtensions != null && !this.userAgentExtensions.isEmpty()) {
            request.setUserAgentExtensions(this.userAgentExtensions);
        }
        request.buildUrl();
        this.logRequest(request);
        Response response = this.httpClient.makeRequest(request);
        if (logger.isDebugEnabled()) {
            logger.debug("status code: {}", (Object)response.getStatusCode());
            Header[] responseHeaders = response.getHeaders();
            logger.debug("response headers:");
            for (int i = 0; i < responseHeaders.length; ++i) {
                logger.debug("responseHeader: {}", (Object)responseHeaders[i]);
            }
        }
        return response;
    }

    public void logRequest(Request request) {
        if (logger.isDebugEnabled()) {
            logger.debug("-- BEGIN Sendgrid API Request --");
            logger.debug("request method: " + (Object)((Object)request.getMethod()));
            logger.debug("request URL: " + request.getUrl().toString());
            Map<String, String> headerParams = request.getHeaders();
            if (headerParams != null && !headerParams.isEmpty()) {
                logger.debug("header parameters: ");
                for (String key : headerParams.keySet()) {
                    if (key.toLowerCase().contains("authorization")) continue;
                    logger.debug(key + ": " + headerParams.get(key));
                }
            }
            logger.debug("-- END Sendgrid API Request --");
        }
    }

    public String getRegion() {
        return this.region;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<String> getUserAgentExtensions() {
        return this.userAgentExtensions;
    }

    public static class Builder {
        private String apiKey;
        private String region;
        private List<String> userAgentExtensions;
        private HttpClient httpClient;

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder userAgentExtensions(List<String> userAgentExtensions) {
            if (userAgentExtensions != null && !userAgentExtensions.isEmpty()) {
                this.userAgentExtensions = new ArrayList<String>(userAgentExtensions);
            }
            return this;
        }

        public ApiKeyRestClient build() {
            if (this.httpClient == null) {
                this.httpClient = new ApiKeyHttpClient();
            }
            return new ApiKeyRestClient(this);
        }
    }
}

