/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.http.httpclient;

import com.sendgrid.constant.EnumConstants;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.http.httpclient.HttpClient;
import com.sendgrid.http.httpclient.HttpUtility;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class ApiKeyHttpClient
extends HttpClient {
    protected final org.apache.http.client.HttpClient client;
    private boolean isCustomClient;

    public ApiKeyHttpClient() {
        this(DEFAULT_REQUEST_CONFIG);
    }

    public ApiKeyHttpClient(RequestConfig requestConfig) {
        this(requestConfig, DEFAULT_SOCKET_CONFIG);
    }

    public ApiKeyHttpClient(RequestConfig requestConfig, SocketConfig socketConfig) {
        List<BasicHeader> headers = Arrays.asList(new BasicHeader("X-Sendgrid-Client", "java-5.0.0-rc.1"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        String googleAppEngineVersion = System.getProperty("com.google.appengine.runtime.version");
        boolean isGoogleAppEngine = googleAppEngineVersion != null && !googleAppEngineVersion.isEmpty();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (!isGoogleAppEngine) {
            clientBuilder.useSystemProperties();
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(100);
        this.client = clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers).setRedirectStrategy(this.getRedirectStrategy()).build();
    }

    public ApiKeyHttpClient(HttpClientBuilder clientBuilder) {
        List<BasicHeader> headers = Arrays.asList(new BasicHeader("X-Sendgrid-Client", "java-5.0.0-rc.1"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        this.isCustomClient = true;
        this.client = clientBuilder.setDefaultHeaders(headers).setRedirectStrategy(this.getRedirectStrategy()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response makeRequest(Request request) {
        Response response;
        HttpMethod method = request.getMethod();
        RequestBuilder builder = RequestBuilder.create((String)method.toString()).setUri(request.getUrl()).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        if (request.getBody() != null) {
            StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            builder.setEntity((HttpEntity)entity);
            builder.addHeader("Content-Type", EnumConstants.ContentType.JSON.getValue());
        }
        builder.addHeader("User-Agent", HttpUtility.getUserAgentString(request.getUserAgentExtensions(), this.isCustomClient));
        HttpResponse response2 = null;
        try {
            response2 = this.client.execute(builder.build());
            HttpEntity entity = response2.getEntity();
            response = new Response(entity == null ? null : new BufferedHttpEntity(entity).getContent(), response2.getStatusLine().getStatusCode(), response2.getAllHeaders());
        }
        catch (IOException e) {
            try {
                System.out.println("Exception occurred");
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response2);
                throw throwable;
            }
            HttpClientUtils.closeQuietly((HttpResponse)response2);
            return null;
        }
        HttpClientUtils.closeQuietly((HttpResponse)response2);
        return response;
    }
}

