/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.accountprovisioning;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.accountprovisioning.models.AccountList;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListAccount
extends ApiKeyBase {
    private String offset;
    private Integer limit;

    @Override
    public ApiResponse<AccountList> send(ApiKeyRestClient client) {
        String path = "/v3/partners/accounts";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListAccount creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AccountList>(statusCode, JsonUtil.fromJson(response.getStream(), AccountList.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

