/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.alerts;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.alerts.models.CreateAlert201Response;
import com.sendgrid.rest.api.v3.alerts.models.CreateAlertRequest;
import com.sendgrid.rest.api.v3.alerts.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateAlert
extends ApiKeyBase {
    private String onBehalfOf;
    private CreateAlertRequest createAlertRequest;

    @Override
    public ApiResponse<CreateAlert201Response> send(ApiKeyRestClient client) {
        String path = "/v3/alerts";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateAlert creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<CreateAlert201Response>(statusCode, JsonUtil.fromJson(response.getStream(), CreateAlert201Response.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.createAlertRequest != null) {
            request.addBody(JsonUtil.toJson(this.createAlertRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setCreateAlertRequest(CreateAlertRequest createAlertRequest) {
        this.createAlertRequest = createAlertRequest;
    }
}

