/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.AuthenticateDomainRequest;
import com.sendgrid.rest.api.v3.domainauthentication.models.AuthenticatedDomain;
import com.sendgrid.util.JsonUtil;

public class AuthenticateDomain
extends ApiKeyBase {
    private String onBehalfOf;
    private AuthenticateDomainRequest authenticateDomainRequest;

    @Override
    public ApiResponse<AuthenticatedDomain> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthenticateDomain creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AuthenticatedDomain>(statusCode, JsonUtil.fromJson(response.getStream(), AuthenticatedDomain.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.authenticateDomainRequest != null) {
            request.addBody(JsonUtil.toJson(this.authenticateDomainRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setAuthenticateDomainRequest(AuthenticateDomainRequest authenticateDomainRequest) {
        this.authenticateDomainRequest = authenticateDomainRequest;
    }
}

