/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.AuthenticatedDomain;
import com.sendgrid.util.JsonUtil;

public class GetAuthenticatedDomain
extends ApiKeyBase {
    private final String domainId;
    private String onBehalfOf;

    @Override
    public ApiResponse<AuthenticatedDomain> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains/{domain_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetAuthenticatedDomain creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AuthenticatedDomain>(statusCode, JsonUtil.fromJson(response.getStream(), AuthenticatedDomain.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.domainId != null) {
            request.addPathParam("domain_id", this.domainId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public GetAuthenticatedDomain(String domainId) {
        this.domainId = domainId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

