/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.emailactivity;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.emailactivity.models.GetMessage404Response;
import com.sendgrid.rest.api.v3.emailactivity.models.ListMessage429Response;
import com.sendgrid.rest.api.v3.emailactivity.models.Message;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetMessage
extends ApiKeyBase {
    private final String msgId;

    @Override
    public ApiResponse<Message> send(ApiKeyRestClient client) {
        String path = "/v3/messages/{msg_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetMessage creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ListMessage429Response error = JsonUtil.fromJson(response.getStream(), ListMessage429Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetMessage404Response error = JsonUtil.fromJson(response.getStream(), GetMessage404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "429")) {
                ListMessage429Response error = JsonUtil.fromJson(response.getStream(), ListMessage429Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Message>(statusCode, JsonUtil.fromJson(response.getStream(), Message.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.msgId != null) {
            request.addPathParam("msg_id", this.msgId.toString());
        }
    }

    public GetMessage(String msgId) {
        this.msgId = msgId;
    }
}

