/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.emailactivity;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.emailactivity.models.ListMessage200Response;
import com.sendgrid.rest.api.v3.emailactivity.models.ListMessage400Response;
import com.sendgrid.rest.api.v3.emailactivity.models.ListMessage429Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.math.BigDecimal;

public class ListMessage
extends ApiKeyBase {
    private final String query;
    private BigDecimal limit;

    @Override
    public ApiResponse<ListMessage200Response> send(ApiKeyRestClient client) {
        String path = "/v3/messages";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListMessage creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ListMessage400Response error = JsonUtil.fromJson(response.getStream(), ListMessage400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "429")) {
                ListMessage429Response error = JsonUtil.fromJson(response.getStream(), ListMessage429Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListMessage200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListMessage200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.query != null) {
            request.addQueryParam("query", this.query.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
    }

    public ListMessage(String query) {
        this.query = query;
    }

    public void setLimit(BigDecimal limit) {
        this.limit = limit;
    }
}

