/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.emailvalidation;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.emailvalidation.models.ErrorResponse;
import com.sendgrid.rest.api.v3.emailvalidation.models.GetValidationsEmailJobsJobId200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetEmailJobForVerification
extends ApiKeyBase {
    private final String jobId;

    @Override
    public ApiResponse<GetValidationsEmailJobsJobId200Response> send(ApiKeyRestClient client) {
        String path = "/v3/validations/email/jobs/{job_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetEmailJobForVerification creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetValidationsEmailJobsJobId200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetValidationsEmailJobsJobId200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.jobId != null) {
            request.addPathParam("job_id", this.jobId.toString());
        }
    }

    public GetEmailJobForVerification(String jobId) {
        this.jobId = jobId;
    }
}

