/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.emailvalidation;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.emailvalidation.models.ErrorResponse;
import com.sendgrid.rest.api.v3.emailvalidation.models.ListEmailJobForVerificationRequest;
import com.sendgrid.rest.api.v3.emailvalidation.models.PutValidationsEmailJobs200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListEmailJobForVerification
extends ApiKeyBase {
    private ListEmailJobForVerificationRequest listEmailJobForVerificationRequest;

    @Override
    public ApiResponse<PutValidationsEmailJobs200Response> send(ApiKeyRestClient client) {
        String path = "/v3/validations/email/jobs";
        Request request = new Request(HttpMethod.PUT, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListEmailJobForVerification creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<PutValidationsEmailJobs200Response>(statusCode, JsonUtil.fromJson(response.getStream(), PutValidationsEmailJobs200Response.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.listEmailJobForVerificationRequest != null) {
            request.addBody(JsonUtil.toJson(this.listEmailJobForVerificationRequest));
        }
    }

    public void setListEmailJobForVerificationRequest(ListEmailJobForVerificationRequest listEmailJobForVerificationRequest) {
        this.listEmailJobForVerificationRequest = listEmailJobForVerificationRequest;
    }
}

