/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.integrations;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.integrations.models.DeleteIntegration404Response;
import com.sendgrid.rest.api.v3.integrations.models.GetIntegrationsByUser403Response;
import com.sendgrid.rest.api.v3.integrations.models.GetIntegrationsByUser500Response;
import com.sendgrid.rest.api.v3.integrations.models.Integration;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class FindIntegrationById
extends ApiKeyBase {
    private final String id;

    @Override
    public ApiResponse<Integration> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/integrations/{id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FindIntegrationById creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                GetIntegrationsByUser403Response error = JsonUtil.fromJson(response.getStream(), GetIntegrationsByUser403Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DeleteIntegration404Response error = JsonUtil.fromJson(response.getStream(), DeleteIntegration404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                GetIntegrationsByUser500Response error = JsonUtil.fromJson(response.getStream(), GetIntegrationsByUser500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Integration>(statusCode, JsonUtil.fromJson(response.getStream(), Integration.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    public FindIntegrationById(String id) {
        this.id = id;
    }
}

