/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipaddressmanagement;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.IpAddressManagementErrorResponse;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.ListIpPool200Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.Region7;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListIpPool
extends ApiKeyBase {
    private Integer limit;
    private Integer afterKey;
    private String ip;
    private Region7 region;
    private Boolean includeRegion;

    @Override
    public ApiResponse<ListIpPool200Response> send(ApiKeyRestClient client) {
        String path = "/v3/send_ips/pools";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListIpPool creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListIpPool200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListIpPool200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.afterKey != null) {
            request.addQueryParam("after_key", this.afterKey.toString());
        }
        if (this.ip != null) {
            request.addQueryParam("ip", this.ip.toString());
        }
        if (this.region != null) {
            request.addQueryParam("region", this.region.toString());
        }
        if (this.includeRegion != null) {
            request.addQueryParam("include_region", this.includeRegion.toString());
        }
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setAfterKey(Integer afterKey) {
        this.afterKey = afterKey;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setRegion(Region7 region) {
        this.region = region;
    }

    public void setIncludeRegion(Boolean includeRegion) {
        this.includeRegion = includeRegion;
    }
}

