/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipaddressmanagement;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.IpAddressManagementErrorResponse;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.UpdateIp200Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.UpdateIpRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateIp
extends ApiKeyBase {
    private final String ip;
    private UpdateIpRequest updateIpRequest;

    @Override
    public ApiResponse<UpdateIp200Response> send(ApiKeyRestClient client) {
        String path = "/v3/send_ips/ips/{ip}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<UpdateIp200Response>(statusCode, JsonUtil.fromJson(response.getStream(), UpdateIp200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.ip != null) {
            request.addPathParam("ip", this.ip.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateIpRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateIpRequest));
        }
    }

    public UpdateIp(String ip) {
        this.ip = ip;
    }

    public void setUpdateIpRequest(UpdateIpRequest updateIpRequest) {
        this.updateIpRequest = updateIpRequest;
    }
}

