/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipaddressmanagement;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.IpAddressManagementErrorResponse;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.UpdateIpPool200Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.UpdateIpPoolRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateIpPool
extends ApiKeyBase {
    private final String poolid;
    private UpdateIpPoolRequest updateIpPoolRequest;

    @Override
    public ApiResponse<UpdateIpPool200Response> send(ApiKeyRestClient client) {
        String path = "/v3/send_ips/pools/{poolid}";
        Request request = new Request(HttpMethod.PUT, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateIpPool creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<UpdateIpPool200Response>(statusCode, JsonUtil.fromJson(response.getStream(), UpdateIpPool200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.poolid != null) {
            request.addPathParam("poolid", this.poolid.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateIpPoolRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateIpPoolRequest));
        }
    }

    public UpdateIpPool(String poolid) {
        this.poolid = poolid;
    }

    public void setUpdateIpPoolRequest(UpdateIpPoolRequest updateIpPoolRequest) {
        this.updateIpPoolRequest = updateIpPoolRequest;
    }
}

