/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ips;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ips.models.GetIpPool200Response;
import com.sendgrid.rest.api.v3.ips.models.GetIpPool404Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetIpPool
extends ApiKeyBase {
    private final String poolName;

    @Override
    public ApiResponse<GetIpPool200Response> send(ApiKeyRestClient client) {
        String path = "/v3/ips/pools/{pool_name}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetIpPool creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetIpPool404Response error = JsonUtil.fromJson(response.getStream(), GetIpPool404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetIpPool200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetIpPool200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.poolName != null) {
            request.addPathParam("pool_name", this.poolName.toString());
        }
    }

    public GetIpPool(String poolName) {
        this.poolName = poolName;
    }
}

