/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ips;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ips.models.IpPools200;
import com.sendgrid.rest.api.v3.ips.models.UpdateIpPool404Response;
import com.sendgrid.rest.api.v3.ips.models.UpdateIpPoolRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateIpPool
extends ApiKeyBase {
    private final String poolName;
    private UpdateIpPoolRequest updateIpPoolRequest;

    @Override
    public ApiResponse<IpPools200> send(ApiKeyRestClient client) {
        String path = "/v3/ips/pools/{pool_name}";
        Request request = new Request(HttpMethod.PUT, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateIpPool creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                UpdateIpPool404Response error = JsonUtil.fromJson(response.getStream(), UpdateIpPool404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<IpPools200>(statusCode, JsonUtil.fromJson(response.getStream(), IpPools200.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.poolName != null) {
            request.addPathParam("pool_name", this.poolName.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateIpPoolRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateIpPoolRequest));
        }
    }

    public UpdateIpPool(String poolName) {
        this.poolName = poolName;
    }

    public void setUpdateIpPoolRequest(UpdateIpPoolRequest updateIpPoolRequest) {
        this.updateIpPoolRequest = updateIpPoolRequest;
    }
}

