/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccontactdb;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.AddRecipientRequestInner;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ContactdbRecipientResponse201;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class AddRecipient
extends ApiKeyBase {
    private String onBehalfOf;
    private List<AddRecipientRequestInner> addRecipientRequestInner;

    @Override
    public ApiResponse<ContactdbRecipientResponse201> send(ApiKeyRestClient client) {
        String path = "/v3/contactdb/recipients";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddRecipient creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ContactdbRecipientResponse201>(statusCode, JsonUtil.fromJson(response.getStream(), ContactdbRecipientResponse201.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.addRecipientRequestInner != null) {
            request.addBody(JsonUtil.toJson(this.addRecipientRequestInner));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setAddRecipientRequestInner(List<AddRecipientRequestInner> addRecipientRequestInner) {
        this.addRecipientRequestInner = addRecipientRequestInner;
    }
}

