/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccontactdb;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ContactdbSegments;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetSegment
extends ApiKeyBase {
    private final String segmentsId;
    private final Integer segmentId;
    private String onBehalfOf;

    @Override
    public ApiResponse<ContactdbSegments> send(ApiKeyRestClient client) {
        String path = "/v3/contactdb/segments/{segments_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ContactdbSegments>(statusCode, JsonUtil.fromJson(response.getStream(), ContactdbSegments.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.segmentsId != null) {
            request.addPathParam("segments_id", this.segmentsId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.segmentId != null) {
            request.addQueryParam("segment_id", this.segmentId.toString());
        }
    }

    public GetSegment(String segmentsId, Integer segmentId) {
        this.segmentsId = segmentsId;
        this.segmentId = segmentId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

