/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccontactdb;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ErrorResponse;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ListRecipientsFromContactDbList200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListRecipientsFromContactDbList
extends ApiKeyBase {
    private final Integer listsId;
    private Integer page;
    private Integer pageSize;
    private final Integer listId;
    private String onBehalfOf;

    @Override
    public ApiResponse<ListRecipientsFromContactDbList200Response> send(ApiKeyRestClient client) {
        String path = "/v3/contactdb/lists/{lists_id}/recipients";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListRecipientsFromContactDbList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListRecipientsFromContactDbList200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListRecipientsFromContactDbList200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.listsId != null) {
            request.addPathParam("lists_id", this.listsId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.page != null) {
            request.addQueryParam("page", this.page.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.listId != null) {
            request.addQueryParam("list_id", this.listId.toString());
        }
    }

    public ListRecipientsFromContactDbList(Integer listsId, Integer listId) {
        this.listsId = listsId;
        this.listId = listId;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

