/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccustomfields;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccustomfields.models.CreateFieldDefinition200Response;
import com.sendgrid.rest.api.v3.mccustomfields.models.CreateFieldDefinition400Response;
import com.sendgrid.rest.api.v3.mccustomfields.models.CreateFieldDefinitionRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateFieldDefinition
extends ApiKeyBase {
    private CreateFieldDefinitionRequest createFieldDefinitionRequest;

    @Override
    public ApiResponse<CreateFieldDefinition200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/field_definitions";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateFieldDefinition creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                CreateFieldDefinition400Response error = JsonUtil.fromJson(response.getStream(), CreateFieldDefinition400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<CreateFieldDefinition200Response>(statusCode, JsonUtil.fromJson(response.getStream(), CreateFieldDefinition200Response.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.createFieldDefinitionRequest != null) {
            request.addBody(JsonUtil.toJson(this.createFieldDefinitionRequest));
        }
    }

    public void setCreateFieldDefinitionRequest(CreateFieldDefinitionRequest createFieldDefinitionRequest) {
        this.createFieldDefinitionRequest = createFieldDefinitionRequest;
    }
}

