/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcdesigns;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcdesigns.models.ListDesign200Response;
import com.sendgrid.util.JsonUtil;

public class ListPreBuiltDesign
extends ApiKeyBase {
    private Integer pageSize;
    private String pageToken;
    private Boolean summary;

    @Override
    public ApiResponse<ListDesign200Response> send(ApiKeyRestClient client) {
        String path = "/v3/designs/pre-builts";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListPreBuiltDesign creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListDesign200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListDesign200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
        if (this.summary != null) {
            request.addQueryParam("summary", this.summary.toString());
        }
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public void setSummary(Boolean summary) {
        this.summary = summary;
    }
}

