/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.CreateMarketingList400Response;
import com.sendgrid.rest.api.v3.mclists.models.CreateMarketingListRequest;
import com.sendgrid.rest.api.v3.mclists.models.ModelList;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateMarketingList
extends ApiKeyBase {
    private CreateMarketingListRequest createMarketingListRequest;

    @Override
    public ApiResponse<ModelList> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateMarketingList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                CreateMarketingList400Response error = JsonUtil.fromJson(response.getStream(), CreateMarketingList400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ModelList>(statusCode, JsonUtil.fromJson(response.getStream(), ModelList.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.createMarketingListRequest != null) {
            request.addBody(JsonUtil.toJson(this.createMarketingListRequest));
        }
    }

    public void setCreateMarketingListRequest(CreateMarketingListRequest createMarketingListRequest) {
        this.createMarketingListRequest = createMarketingListRequest;
    }
}

