/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.DeleteContact202Response;
import com.sendgrid.rest.api.v3.mclists.models.Error;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteContact
extends ApiKeyBase {
    private final String id;
    private final String contactIds;

    @Override
    public ApiResponse<DeleteContact202Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists/{id}/contacts";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteContact creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                Error error = JsonUtil.fromJson(response.getStream(), Error.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<DeleteContact202Response>(statusCode, JsonUtil.fromJson(response.getStream(), DeleteContact202Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.contactIds != null) {
            request.addQueryParam("contact_ids", this.contactIds.toString());
        }
    }

    public DeleteContact(String id, String contactIds) {
        this.id = id;
        this.contactIds = contactIds;
    }
}

