/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.DeleteMarketingList404Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteMarketingList
extends ApiKeyBase {
    private final String id;
    private Boolean deleteContacts;

    @Override
    public ApiResponse<String> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists/{id}";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteMarketingList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DeleteMarketingList404Response error = JsonUtil.fromJson(response.getStream(), DeleteMarketingList404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<String>(statusCode, JsonUtil.fromJson(response.getStream(), String.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.deleteContacts != null) {
            request.addQueryParam("delete_contacts", this.deleteContacts.toString());
        }
    }

    public DeleteMarketingList(String id) {
        this.id = id;
    }

    public void setDeleteContacts(Boolean deleteContacts) {
        this.deleteContacts = deleteContacts;
    }
}

