/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.Error;
import com.sendgrid.rest.api.v3.mclists.models.GetMarketingList200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class GetMarketingList
extends ApiKeyBase {
    private final String id;
    private Boolean contactSample;

    @Override
    public ApiResponse<GetMarketingList200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists/{id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetMarketingList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                TypeReference<List<Error>> listTypeReference = new TypeReference<List<Error>>(){};
                List<Error> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetMarketingList200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetMarketingList200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.contactSample != null) {
            request.addQueryParam("contact_sample", this.contactSample.toString());
        }
    }

    public GetMarketingList(String id) {
        this.id = id;
    }

    public void setContactSample(Boolean contactSample) {
        this.contactSample = contactSample;
    }
}

