/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.CreateMarketingList400Response;
import com.sendgrid.rest.api.v3.mclists.models.ModelList;
import com.sendgrid.rest.api.v3.mclists.models.UpdateMarketingListRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateMarketingList
extends ApiKeyBase {
    private final String id;
    private UpdateMarketingListRequest updateMarketingListRequest;

    @Override
    public ApiResponse<ModelList> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists/{id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateMarketingList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                CreateMarketingList400Response error = JsonUtil.fromJson(response.getStream(), CreateMarketingList400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ModelList>(statusCode, JsonUtil.fromJson(response.getStream(), ModelList.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateMarketingListRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateMarketingListRequest));
        }
    }

    public UpdateMarketingList(String id) {
        this.id = id;
    }

    public void setUpdateMarketingListRequest(UpdateMarketingListRequest updateMarketingListRequest) {
        this.updateMarketingListRequest = updateMarketingListRequest;
    }
}

