/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsegments;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsegments.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mcsegments.models.FullSegment;
import com.sendgrid.rest.api.v3.mcsegments.models.GetSegment404Response;
import com.sendgrid.rest.api.v3.mcsegments.models.ListSegment500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.UUID;

public class GetSegment
extends ApiKeyBase {
    private final UUID segmentId;
    private Boolean queryJson;

    @Override
    public ApiResponse<FullSegment> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/segments/{segment_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetSegment404Response error = JsonUtil.fromJson(response.getStream(), GetSegment404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ListSegment500Response error = JsonUtil.fromJson(response.getStream(), ListSegment500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<FullSegment>(statusCode, JsonUtil.fromJson(response.getStream(), FullSegment.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.segmentId != null) {
            request.addPathParam("segment_id", this.segmentId.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.queryJson != null) {
            request.addQueryParam("query_json", this.queryJson.toString());
        }
    }

    public GetSegment(UUID segmentId) {
        this.segmentId = segmentId;
    }

    public void setQueryJson(Boolean queryJson) {
        this.queryJson = queryJson;
    }
}

