/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsegments2;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsegments2.models.ErrorsSegmentV2;
import com.sendgrid.rest.api.v3.mcsegments2.models.Segment2xx;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetSegment
extends ApiKeyBase {
    private final String segmentId;
    private Boolean contactsSample;

    @Override
    public ApiResponse<Segment2xx> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/segments/2.0/{segment_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Segment2xx>(statusCode, JsonUtil.fromJson(response.getStream(), Segment2xx.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.segmentId != null) {
            request.addPathParam("segment_id", this.segmentId.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.contactsSample != null) {
            request.addQueryParam("contacts_sample", this.contactsSample.toString());
        }
    }

    public GetSegment(String segmentId) {
        this.segmentId = segmentId;
    }

    public void setContactsSample(Boolean contactsSample) {
        this.contactsSample = contactsSample;
    }
}

