/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsegments2;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsegments2.models.AllSegments200;
import com.sendgrid.rest.api.v3.mcsegments2.models.ErrorsSegmentV2;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class ListSegment
extends ApiKeyBase {
    private List<String> ids;
    private String parentListIds;
    private Boolean noParentListId;

    @Override
    public ApiResponse<AllSegments200> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/segments/2.0";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AllSegments200>(statusCode, response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.ids != null) {
            request.addQueryParam("ids", this.ids.toString());
        }
        if (this.parentListIds != null) {
            request.addQueryParam("parent_list_ids", this.parentListIds.toString());
        }
        if (this.noParentListId != null) {
            request.addQueryParam("no_parent_list_id", this.noParentListId.toString());
        }
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public void setParentListIds(String parentListIds) {
        this.parentListIds = parentListIds;
    }

    public void setNoParentListId(Boolean noParentListId) {
        this.noParentListId = noParentListId;
    }
}

