/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsinglesends;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.ListSingleSend200Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.ListSingleSend500Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.SinglesendSearch;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class SearchSingleSend
extends ApiKeyBase {
    private Integer pageSize;
    private String pageToken;
    private SinglesendSearch singlesendSearch;

    @Override
    public ApiResponse<ListSingleSend200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/singlesends/search";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SearchSingleSend creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListSingleSend200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListSingleSend200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
    }

    private void addBody(Request request) {
        if (this.singlesendSearch != null) {
            request.addBody(JsonUtil.toJson(this.singlesendSearch));
        }
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public void setSinglesendSearch(SinglesendSearch singlesendSearch) {
        this.singlesendSearch = singlesendSearch;
    }
}

