/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcstats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcstats.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mcstats.models.SinglesendsResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class ListSingleSendStat
extends ApiKeyBase {
    private List<String> singlesendIds;
    private Integer pageSize;
    private String pageToken;

    @Override
    public ApiResponse<SinglesendsResponse> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/stats/singlesends";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSingleSendStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SinglesendsResponse>(statusCode, JsonUtil.fromJson(response.getStream(), SinglesendsResponse.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.singlesendIds != null) {
            request.addQueryParam("singlesend_ids", this.singlesendIds.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
    }

    public void setSinglesendIds(List<String> singlesendIds) {
        this.singlesendIds = singlesendIds;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }
}

