/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcstats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcstats.models.AbPhaseId;
import com.sendgrid.rest.api.v3.mcstats.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mcstats.models.Items2;
import com.sendgrid.rest.api.v3.mcstats.models.SinglesendsLinkStatsResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;
import java.util.UUID;

public class ListSingleSendTrackingStat
extends ApiKeyBase {
    private final String id;
    private Integer pageSize;
    private String pageToken;
    private List<Items2> groupBy;
    private UUID abVariationId;
    private AbPhaseId abPhaseId;

    @Override
    public ApiResponse<SinglesendsLinkStatsResponse> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/stats/singlesends/{id}/links";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSingleSendTrackingStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SinglesendsLinkStatsResponse>(statusCode, JsonUtil.fromJson(response.getStream(), SinglesendsLinkStatsResponse.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
        if (this.groupBy != null) {
            request.addQueryParam("group_by", this.groupBy.toString());
        }
        if (this.abVariationId != null) {
            request.addQueryParam("ab_variation_id", this.abVariationId.toString());
        }
        if (this.abPhaseId != null) {
            request.addQueryParam("ab_phase_id", this.abPhaseId.toString());
        }
    }

    public ListSingleSendTrackingStat(String id) {
        this.id = id;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public void setGroupBy(List<Items2> groupBy) {
        this.groupBy = groupBy;
    }

    public void setAbVariationId(UUID abVariationId) {
        this.abVariationId = abVariationId;
    }

    public void setAbPhaseId(AbPhaseId abPhaseId) {
        this.abPhaseId = abPhaseId;
    }
}

