/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mctest;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mctest.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mctest.models.SendTestMarketingEmailRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class SendTestMarketingEmail
extends ApiKeyBase {
    private SendTestMarketingEmailRequest sendTestMarketingEmailRequest;

    @Override
    public ApiResponse<Object> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/test/send_email";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SendTestMarketingEmail creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Object>(statusCode, JsonUtil.fromJson(response.getStream(), Object.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.sendTestMarketingEmailRequest != null) {
            request.addBody(JsonUtil.toJson(this.sendTestMarketingEmailRequest));
        }
    }

    public void setSendTestMarketingEmailRequest(SendTestMarketingEmailRequest sendTestMarketingEmailRequest) {
        this.sendTestMarketingEmailRequest = sendTestMarketingEmailRequest;
    }
}

