/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.scheduledsends;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.scheduledsends.models.CancelOrPauseAScheduledSendRequest;
import com.sendgrid.rest.api.v3.scheduledsends.models.ErrorResponse;
import com.sendgrid.rest.api.v3.scheduledsends.models.ScheduledSendStatus;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateScheduledSend
extends ApiKeyBase {
    private String onBehalfOf;
    private CancelOrPauseAScheduledSendRequest cancelOrPauseAScheduledSendRequest;

    @Override
    public ApiResponse<ScheduledSendStatus> send(ApiKeyRestClient client) {
        String path = "/v3/user/scheduled_sends";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateScheduledSend creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ScheduledSendStatus>(statusCode, JsonUtil.fromJson(response.getStream(), ScheduledSendStatus.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.cancelOrPauseAScheduledSendRequest != null) {
            request.addBody(JsonUtil.toJson(this.cancelOrPauseAScheduledSendRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setCancelOrPauseAScheduledSendRequest(CancelOrPauseAScheduledSendRequest cancelOrPauseAScheduledSendRequest) {
        this.cancelOrPauseAScheduledSendRequest = cancelOrPauseAScheduledSendRequest;
    }
}

