/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.scopes;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.scopes.models.ApproveScopeRequest200Response;
import com.sendgrid.rest.api.v3.scopes.models.DenyScopeRequest404Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ApproveScopeRequest
extends ApiKeyBase {
    private final String requestId;

    @Override
    public ApiResponse<ApproveScopeRequest200Response> send(ApiKeyRestClient client) {
        String path = "/v3/scopes/requests/{request_id}/approve";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ApproveScopeRequest creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DenyScopeRequest404Response error = JsonUtil.fromJson(response.getStream(), DenyScopeRequest404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ApproveScopeRequest200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ApproveScopeRequest200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.requestId != null) {
            request.addPathParam("request_id", this.requestId.toString());
        }
    }

    public ApproveScopeRequest(String requestId) {
        this.requestId = requestId;
    }
}

