/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.subusers;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.subusers.models.CreateSubuserRequest;
import com.sendgrid.rest.api.v3.subusers.models.ErrorResponse;
import com.sendgrid.rest.api.v3.subusers.models.SubuserPost;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateSubuser
extends ApiKeyBase {
    private CreateSubuserRequest createSubuserRequest;

    @Override
    public ApiResponse<SubuserPost> send(ApiKeyRestClient client) {
        String path = "/v3/subusers";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateSubuser creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SubuserPost>(statusCode, JsonUtil.fromJson(response.getStream(), SubuserPost.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.createSubuserRequest != null) {
            request.addBody(JsonUtil.toJson(this.createSubuserRequest));
        }
    }

    public void setCreateSubuserRequest(CreateSubuserRequest createSubuserRequest) {
        this.createSubuserRequest = createSubuserRequest;
    }
}

