/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.subusers;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.subusers.models.CategoryStats;
import com.sendgrid.rest.api.v3.subusers.models.SortByDirection2;
import com.sendgrid.util.JsonUtil;

public class ListStatSum
extends ApiKeyBase {
    private SortByDirection2 sortByDirection;
    private final String startDate;
    private String endDate;
    private Integer limit;
    private Integer offset;
    private String aggregatedBy;
    private String sortByMetric;

    @Override
    public ApiResponse<CategoryStats> send(ApiKeyRestClient client) {
        String path = "/v3/subusers/stats/sums";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListStatSum creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<CategoryStats>(statusCode, JsonUtil.fromJson(response.getStream(), CategoryStats.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.sortByDirection != null) {
            request.addQueryParam("sort_by_direction", this.sortByDirection.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
        if (this.aggregatedBy != null) {
            request.addQueryParam("aggregated_by", this.aggregatedBy.toString());
        }
        if (this.sortByMetric != null) {
            request.addQueryParam("sort_by_metric", this.sortByMetric.toString());
        }
    }

    public ListStatSum(String startDate) {
        this.startDate = startDate;
    }

    public void setSortByDirection(SortByDirection2 sortByDirection) {
        this.sortByDirection = sortByDirection;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setAggregatedBy(String aggregatedBy) {
        this.aggregatedBy = aggregatedBy;
    }

    public void setSortByMetric(String sortByMetric) {
        this.sortByMetric = sortByMetric;
    }
}

