/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.subusers;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.subusers.models.ErrorResponse;
import com.sendgrid.rest.api.v3.subusers.models.Region;
import com.sendgrid.rest.api.v3.subusers.models.Subuser;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class ListSubuser
extends ApiKeyBase {
    private String username;
    private Integer limit;
    private Region region;
    private Boolean includeRegion;
    private Integer offset;

    @Override
    public ApiResponse<List<Subuser>> send(ApiKeyRestClient client) {
        String path = "/v3/subusers";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSubuser creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<Subuser>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.username != null) {
            request.addQueryParam("username", this.username.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.region != null) {
            request.addQueryParam("region", this.region.toString());
        }
        if (this.includeRegion != null) {
            request.addQueryParam("include_region", this.includeRegion.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setIncludeRegion(Boolean includeRegion) {
        this.includeRegion = includeRegion;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}

