/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.subusers;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.subusers.models.SortByDirection;
import com.sendgrid.rest.api.v3.subusers.models.SubuserStats;
import com.sendgrid.util.JsonUtil;

public class ListSubuserMonthlyStat
extends ApiKeyBase {
    private final String subuserName;
    private final String date;
    private String sortByMetric;
    private SortByDirection sortByDirection;
    private Integer limit;
    private Integer offset;

    @Override
    public ApiResponse<SubuserStats> send(ApiKeyRestClient client) {
        String path = "/v3/subusers/{subuser_name}/stats/monthly";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSubuserMonthlyStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SubuserStats>(statusCode, JsonUtil.fromJson(response.getStream(), SubuserStats.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.subuserName != null) {
            request.addPathParam("subuser_name", this.subuserName.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.date != null) {
            request.addQueryParam("date", this.date.toString());
        }
        if (this.sortByMetric != null) {
            request.addQueryParam("sort_by_metric", this.sortByMetric.toString());
        }
        if (this.sortByDirection != null) {
            request.addQueryParam("sort_by_direction", this.sortByDirection.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
    }

    public ListSubuserMonthlyStat(String subuserName, String date) {
        this.subuserName = subuserName;
        this.date = date;
    }

    public void setSortByMetric(String sortByMetric) {
        this.sortByMetric = sortByMetric;
    }

    public void setSortByDirection(SortByDirection sortByDirection) {
        this.sortByDirection = sortByDirection;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}

