/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.suppressions;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.suppressions.models.DeleteSuppressionBlocksRequest;
import com.sendgrid.util.JsonUtil;

public class DeleteSuppressionBlocks
extends ApiKeyBase {
    private String onBehalfOf;
    private DeleteSuppressionBlocksRequest deleteSuppressionBlocksRequest;

    @Override
    public ApiResponse<Object> send(ApiKeyRestClient client) {
        String path = "/v3/suppression/blocks";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteSuppressionBlocks creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Object>(statusCode, JsonUtil.fromJson(response.getStream(), Object.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.deleteSuppressionBlocksRequest != null) {
            request.addBody(JsonUtil.toJson(this.deleteSuppressionBlocksRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setDeleteSuppressionBlocksRequest(DeleteSuppressionBlocksRequest deleteSuppressionBlocksRequest) {
        this.deleteSuppressionBlocksRequest = deleteSuppressionBlocksRequest;
    }
}

