/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.templates;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.templates.models.TransactionalTemplateVersionCreate;
import com.sendgrid.rest.api.v3.templates.models.TransactionalTemplateVersionOutput;
import com.sendgrid.util.JsonUtil;
import java.util.UUID;

public class CreateTemplateVersion
extends ApiKeyBase {
    private final UUID templateId;
    private String onBehalfOf;
    private TransactionalTemplateVersionCreate transactionalTemplateVersionCreate;

    @Override
    public ApiResponse<TransactionalTemplateVersionOutput> send(ApiKeyRestClient client) {
        String path = "/v3/templates/{template_id}/versions";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateTemplateVersion creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<TransactionalTemplateVersionOutput>(statusCode, JsonUtil.fromJson(response.getStream(), TransactionalTemplateVersionOutput.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.templateId != null) {
            request.addPathParam("template_id", this.templateId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.transactionalTemplateVersionCreate != null) {
            request.addBody(JsonUtil.toJson(this.transactionalTemplateVersionCreate));
        }
    }

    public CreateTemplateVersion(UUID templateId) {
        this.templateId = templateId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setTransactionalTemplateVersionCreate(TransactionalTemplateVersionCreate transactionalTemplateVersionCreate) {
        this.transactionalTemplateVersionCreate = transactionalTemplateVersionCreate;
    }
}

