/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.templates;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.templates.models.Generations;
import com.sendgrid.rest.api.v3.templates.models.ListTemplate200Response;
import com.sendgrid.rest.api.v3.templates.models.ListTemplate400Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.math.BigDecimal;

public class ListTemplate
extends ApiKeyBase {
    private Generations generations;
    private final BigDecimal pageSize;
    private String pageToken;
    private String onBehalfOf;

    @Override
    public ApiResponse<ListTemplate200Response> send(ApiKeyRestClient client) {
        String path = "/v3/templates";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListTemplate creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ListTemplate400Response error = JsonUtil.fromJson(response.getStream(), ListTemplate400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListTemplate200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListTemplate200Response.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.generations != null) {
            request.addQueryParam("generations", this.generations.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
    }

    public ListTemplate(BigDecimal pageSize) {
        this.pageSize = pageSize;
    }

    public void setGenerations(Generations generations) {
        this.generations = generations;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

