/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.verifiedsenders;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.CreateVerifiedSender400Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.ErrorResponse;
import com.sendgrid.rest.api.v3.verifiedsenders.models.VerifiedSenderRequest;
import com.sendgrid.rest.api.v3.verifiedsenders.models.VerifiedSenderResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class CreateVerifiedSender
extends ApiKeyBase {
    private VerifiedSenderRequest verifiedSenderRequest;

    @Override
    public ApiResponse<VerifiedSenderResponse> send(ApiKeyRestClient client) {
        String path = "/v3/verified_senders";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateVerifiedSender creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                CreateVerifiedSender400Response error = JsonUtil.fromJson(response.getStream(), CreateVerifiedSender400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<VerifiedSenderResponse>(statusCode, JsonUtil.fromJson(response.getStream(), VerifiedSenderResponse.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.verifiedSenderRequest != null) {
            request.addBody(JsonUtil.toJson(this.verifiedSenderRequest));
        }
    }

    public void setVerifiedSenderRequest(VerifiedSenderRequest verifiedSenderRequest) {
        this.verifiedSenderRequest = verifiedSenderRequest;
    }
}

