/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.verifiedsenders;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.DeleteVerifiedSender403Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.DeleteVerifiedSender404Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteVerifiedSender
extends ApiKeyBase {
    private final String id;

    @Override
    public ApiResponse<Object> send(ApiKeyRestClient client) {
        String path = "/v3/verified_senders/{id}";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteVerifiedSender creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                DeleteVerifiedSender403Response error = JsonUtil.fromJson(response.getStream(), DeleteVerifiedSender403Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DeleteVerifiedSender404Response error = JsonUtil.fromJson(response.getStream(), DeleteVerifiedSender404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Object>(statusCode, JsonUtil.fromJson(response.getStream(), Object.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    public DeleteVerifiedSender(String id) {
        this.id = id;
    }
}

